<?php 

// Manual e-mail verification
function pcma_manual_mv_field($field_id, $field, $value, $all_vals) {

	// user categories
	$user_cats = get_terms('pg_user_categories', 'orderby=name&hide_empty=0'); 
	?>
    <table class="widefat lcwp_settings_table pc_settings_block">
      <thead>
        <tr><th colspan="4"><?php _e("Verify manually all / specific categories users e-mail or send them validation e-mails", PCMA_ML); ?></th></tr>
      </thead>
      
      <tr class="pcma_mv_manual_tr">
        <td class"lcwp_sf_label"><?php _e("Every user", PCMA_ML); ?></td>
        <td>
            <input type="button" value="<?php esc_attr_e("Verify", PCMA_ML); ?>" rel="all" class="button-secondary pcma_mv_manual_btn" />
        </td>
        <td>
            <input type="button" value="<?php esc_attr_e("Send validation e-mail", PCMA_ML); ?>" rel="all" class="button-secondary pcma_send_vmail_btn" />
        </td>
        <td>
        	<span class="info pcma_mv_manual_result"></span>
        </td>
      </tr>
      
      <?php foreach($user_cats as $cat) : ?>
        <tr>
          <td class"lcwp_sf_label"><?php echo $cat->name ?></td>
          <td>
            <input type="button" value="<?php esc_attr_e("Verify", PCMA_ML); ?>" rel="<?php echo $cat->term_id ?>" class="button-secondary pcma_mv_manual_btn" />
          </td>
          <td>
            <input type="button" value="<?php esc_attr_e("Send validation e-mail", PCMA_ML); ?>" rel="<?php echo $cat->term_id ?>" class="button-secondary pcma_send_vmail_btn" />
          </td>
          <td>
          	<span class="info pcma_mv_manual_result"></span>
          </td>
        </tr>
      <?php endforeach; ?>
    </table>   
    <?php	
}



// Admin notifier - receiver email address
function pcma_nnu_mail_multi_field($field_id, $field, $value, $all_vals) {
	?>
    <tr class="pcma_<?php echo $field_id ?>">
		<td class="lcwp_sf_label"><label><?php _e("Receiver's e-mail address", PCMA_ML) ?></label></td>
		<td class="lcwp_sf_field" colspan="2">
			
            <?php $val = (is_array($value)) ? implode(',', $value) : $value; ?>
            <input type="text" name="<?php echo esc_attr($field_id) ?>" value="<?php echo esc_attr($val) ?>" autocomplete="off" />
			
            <p class="lcwp_sf_note"><?php _e('E-mail receiving the notification - multiple addresses supported, <strong>comma split</strong>', PCMA_ML) ?></p> 
		</td>
	</tr>
    <?php
}


